<?php
session_start();
require_once '../config/db.php';

// التحقق من صلاحية الدخول
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../src/login.php');
    exit;
}

// إضافة مستخدم جديد
if (isset($_POST['add_user'])) {
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $role = $_POST['role'];
    $stmt = $pdo->prepare('INSERT INTO users (username, email, password, role) VALUES (?, ?, ?, ?)');
    $stmt->execute([$username, $email, $password, $role]);
}

// حذف مستخدم
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare('DELETE FROM users WHERE id = ?');
    $stmt->execute([$id]);
}

// تعديل مستخدم
if (isset($_POST['edit_user'])) {
    $id = intval($_POST['id']);
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $role = $_POST['role'];
    $update_query = 'UPDATE users SET username = ?, email = ?, role = ?';
    $params = [$username, $email, $role];
    if (!empty($_POST['password'])) {
        $update_query .= ', password = ?';
        $params[] = password_hash($_POST['password'], PASSWORD_DEFAULT);
    }
    $update_query .= ' WHERE id = ?';
    $params[] = $id;
    $stmt = $pdo->prepare($update_query);
    $stmt->execute($params);
}

// جلب جميع المستخدمين
$users = $pdo->query('SELECT * FROM users ORDER BY id DESC')->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة المستخدمين</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: #EEEEEE; font-family: 'Cairo', sans-serif; }
        .container { max-width: 900px; margin: 40px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 24px; text-align: center; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 32px; }
        th, td { padding: 10px; border-bottom: 1px solid #EEEEEE; text-align: center; }
        th { background: #EA9218; color: #fff; }
        .btn { padding: 6px 16px; border-radius: 4px; border: none; cursor: pointer; }
        .btn-edit { background: #3A4750; color: #fff; }
        .btn-delete { background: #d00; color: #fff; }
        .form-inline input, .form-inline select { margin: 0 8px 8px 0; padding: 6px; }
        .form-inline { display: flex; flex-wrap: wrap; align-items: center; gap: 8px; margin-bottom: 24px; }
    </style>
</head>
<body>
    <div class="container">
        <h2>إدارة المستخدمين</h2>
        <!-- نموذج إضافة مستخدم جديد -->
        <form class="form-inline" method="post">
            <input type="text" name="username" placeholder="اسم المستخدم" required>
            <input type="email" name="email" placeholder="البريد الإلكتروني" required>
            <input type="password" name="password" placeholder="كلمة المرور" required>
            <select name="role">
                <option value="admin">مدير</option>
                <option value="editor">محرر</option>
                <option value="viewer">مشاهد</option>
            </select>
            <button class="btn" type="submit" name="add_user">إضافة مستخدم</button>
        </form>
        <!-- جدول المستخدمين -->
        <table>
            <tr>
                <th>الرقم</th>
                <th>اسم المستخدم</th>
                <th>البريد الإلكتروني</th>
                <th>الدور</th>
                <th>تاريخ الإنشاء</th>
                <th>تعديل</th>
                <th>حذف</th>
            </tr>
            <?php foreach ($users as $user): ?>
            <tr>
                <form method="post">
                    <td><?= $user['id'] ?></td>
                    <td><input type="text" name="username" value="<?= htmlspecialchars($user['username']) ?>" required></td>
                    <td><input type="email" name="email" value="<?= htmlspecialchars($user['email']) ?>" required></td>
                    <td>
                        <select name="role">
                            <option value="admin" <?= $user['role']=='admin'?'selected':'' ?>>مدير</option>
                            <option value="editor" <?= $user['role']=='editor'?'selected':'' ?>>محرر</option>
                            <option value="viewer" <?= $user['role']=='viewer'?'selected':'' ?>>مشاهد</option>
                        </select>
                    </td>
                    <td><?= $user['created_at'] ?></td>
                    <td>
                        <input type="hidden" name="id" value="<?= $user['id'] ?>">
                        <input type="password" name="password" placeholder="كلمة مرور جديدة (اختياري)">
                        <button class="btn btn-edit" type="submit" name="edit_user">تعديل</button>
                    </td>
                    <td>
                        <a class="btn btn-delete" href="?delete=<?= $user['id'] ?>" onclick="return confirm('هل أنت متأكد من حذف المستخدم؟');">حذف</a>
                    </td>
                </form>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
